/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.sct.gui.wizard;

import com.quantumdata.sct.dao.vo.TestResultVO;
import com.quantumdata.sct.dao.vo.TestSectionVO;
import com.quantumdata.sct.engine.test.TestResultsPanel;
import com.quantumdata.sct.gui.wizard.ActivityCardItemPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.Vector;
import javax.swing.JPanel;

public class TestResultSectionPage
extends ActivityCardItemPanel {
    private int currentTestPageIndex;
    private Vector testPages;
    private JPanel currentDisplay;

    TestResultSectionPage(TestSectionVO testSectionVO, Collection collection) throws Exception {
        this.setLayout(new BorderLayout());
        this.testPages = new Vector(collection.size());
        for (TestResultVO testResultVO : collection) {
            this.testPages.add(new TestResultsPanel(testResultVO));
        }
        this.setDisplay();
    }

    public void setDisplay() {
        TestResultsPanel testResultsPanel = this.getCurrentTestPage();
        if (testResultsPanel != null) {
            if (this.currentDisplay != null) {
                this.remove(this.currentDisplay);
            }
            testResultsPanel.preShow();
            this.currentDisplay = testResultsPanel;
            this.add((Component)this.currentDisplay, "Center");
            this.updateUI();
        }
    }

    private TestResultsPanel getCurrentTestPage() {
        if (this.currentTestPageIndex < 0 || this.currentTestPageIndex > this.testPages.size() - 1) {
            return null;
        }
        return (TestResultsPanel)this.testPages.get(this.currentTestPageIndex);
    }

    public boolean isFirstTest() {
        return this.currentTestPageIndex == 0;
    }

    public boolean isLastTest() {
        return this.currentTestPageIndex == this.testPages.size() - 1;
    }

    public boolean backButtonAction(ActionEvent actionEvent) {
        if (this.currentTestPageIndex > 0) {
            --this.currentTestPageIndex;
            this.setDisplay();
            return false;
        }
        return true;
    }

    public boolean nextButtonAction(ActionEvent actionEvent) {
        if (this.currentTestPageIndex < this.testPages.size() - 1) {
            ++this.currentTestPageIndex;
            this.setDisplay();
            return false;
        }
        return true;
    }

    public int getTestCount() {
        return this.testPages.size();
    }

    public int getTestIndex() {
        return this.currentTestPageIndex;
    }

    public void setFirstIndex() {
        this.currentTestPageIndex = 0;
        this.setDisplay();
    }

    public void setLastIndex() {
        this.currentTestPageIndex = this.testPages.size() - 1;
        this.setDisplay();
    }
}

